<?php
/*
Plugin Name: Simple HTML Minifier
Plugin URI: 
Description: Minify all HTML pages in the buffer.
Text Domain: simple-html-minifier
Domain Path: /
Author: Philippe Gras
Version: 0.1.
Author URI: http://www.qrlug.com/
*/

/************************************************************
 https://websistent.com/how-to-use-php-to-minify-html-output/
 http://php.net/manual/fr/ini.core.php#ini.auto-prepend-file
 http://php.net/manual/fr/function.spl-autoload.php

 https://codex.wordpress.org/Plugin_API/Action_Reference/parse_request

 http://wpengineer.com/2324/register-settings-on-wordpress-multisite/
 https://codex.wordpress.org/Function_Reference/get_site_option
 ***********************************************************/

include 'php-html-css-js-minifier.php';

class BuffyOutput {
	private $_blog_id;
	private $_domain;
	private $_https;
	private $_options;
	private $_switch;
	private $_minify;
	private $_mn_css;
	private $_min_js;

	function __construct() {
		register_activation_hook(__FILE__, array($this, 'buffy_network_ctrl'));
		register_deactivation_hook(__FILE__, array($this, 'buffy_flush_options'));
		add_action('plugins_loaded', array($this, 'buffy_load_textdomain'));
		add_action('admin_menu', array($this, 'buffy_menu_init'));
		add_action('admin_init', array($this, 'buffy_settings_register'));

		add_filter('wp_generate_tag_cloud', array($this, 'buffy_tag_cloud_data'), 3);

		add_action('wp_footer', array($this, 'buffy_proto_testing'));
		// https://codex.wordpress.org/Plugin_API/Action_Reference/wp_loaded
		add_action('wp_loaded', array($this, 'buffy_buffer_to_send'));
		add_action('wp_meta', array($this, 'buffy_sidebar_output'));

		$this->_domain = $_SERVER['HTTP_HOST'];
		$this->_https = is_ssl() ? 'https': 'http';

		if (is_multisite()) {
		    $this->_blog_id = get_current_blog_id();
		    $this->_options = get_blog_option($this->_blog_id, 'buffy_options_array', array('switch' => (bool)$this->_switch, 'minify'=> (bool)$this->_minify, 'mn_css'=> (bool)$this->_mn_css, 'min_js'=> (bool)$this->_min_js));
		    if(empty(get_site_option('buffy_options_array'))) {
			$this->_options = get_blog_option($this->_blog_id, 'buffy_options_array', array('switch' => (bool)0, 'minify'=> (bool)0, 'mn_css'=> (bool)0, 'min_js'=> (bool)0));
			$this->_switch = (bool)0;
			$this->_minify = (bool)0;
			$this->_mn_css = (bool)0;
			$this->_min_js = (bool)0;
		    } else {
			$this->_options = get_blog_option($this->_blog_id, 'buffy_options_array');
			$options = $this->_options;
			$this->_switch = $options['switch'];
			$this->_minify = $options['minify'];
			$this->_mn_css = $options['mn_css'];
			$this->_min_js = $options['min_js'];
		    }
		} else {
		    $this->_blog_id = (int)1;
		    $this->_options = get_option('buffy_options_array', array('switch' => (bool)$this->_switch, 'minify'=> (bool)$this->_minify, 'mn_css'=> (bool)$this->_mn_css, 'min_js'=> (bool)$this->_min_js));
		    if(empty(get_option('buffy_options_array'))) {
			$this->_options = get_option('buffy_options_array', array('switch' => (bool)0, 'minify'=> (bool)0, 'mn_css'=> (bool)0, 'min_js'=> (bool)0));
			$this->_switch = (bool)0;
			$this->_minify = (bool)0;
			$this->_mn_css = (bool)0;
			$this->_min_js = (bool)0;
		    } else {
			$this->_options = get_option('buffy_options_array');
			$options = $this->_options;
			$this->_switch = array_key_exists('switch', $options) ? (bool)$options['switch'] : false;
			$this->_minify = array_key_exists('minify', $options) ? (bool)$options['minify'] : false;
			$this->_mn_css = array_key_exists('mn_css', $options) ? (bool)$options['mn_css'] : false;
			$this->_min_js = array_key_exists('min_js', $options) ? (bool)$options['min_js'] : false;
		    }
		}
	}

	public function buffy_network_ctrl() {
		if (is_multisite() && is_plugin_active_for_network(plugin_basename(__FILE__))) {
		    $this->_options = get_blog_option($this->_blog_id, 'buffy_options_array', array('switch' => (bool)$this->_switch, 'minify'=> (bool)$this->_minify, 'mn_css'=> (bool)$this->_mn_css, 'min_js'=> (bool)$this->_min_js));
		} else {
		    $this->_options = get_option('buffy_options_array', array('switch' => (bool)$this->_switch, 'minify'=> (bool)$this->_minify, 'mn_css'=> (bool)$this->_mn_css, 'min_js'=> (bool)$this->_min_js));
		}
		return $this->_options;
	}

	public function buffy_menu_init() {
		add_options_page('Bufferised Output Options', 'Minifier','manage_options', 'buffyopt', array($this, 'buffy_options_panel'));
	}

	public function buffy_load_textdomain() {
		load_plugin_textdomain('simple-html-minifier', false, dirname(plugin_basename(__FILE__)));
	}

	public function buffy_tag_cloud_data($text) {
	    $quotes = str_replace('\'', '"', $text);
	    $style = str_replace('style="', 'style="display: inline-block; ', $quotes);
	    $cloud = str_replace("</a>", '&nbsp;</a>', $style);

	    return $cloud;
	}

	public function buffy_buffer_to_send() {
		ob_start(array($this, 'buffy_html_output'));
	}

	public function buffy_html_output($buffer) {
		// Replace simple by double quotes in tags:
		$buffer = preg_replace('#=[\']([\S]+)[\']([^%])#', '="$1"$2', $buffer);

		$options = $this->_options;
		$this->_switch = (bool)$options['switch'];
		$this->_minify = (bool)$options['minify'];
		$this->_mn_css = (bool)$options['mn_css'];
		$this->_min_js = (bool)$options['min_js'];

		$this->_https = is_ssl() ? 'https': 'http';
		$external = '#(href|src|content|poster)="http://([^>]+)"#';
		$internal = '#(href|src|content|poster)="//' . $this->_domain . '#';
		$form_val = '#(value|data)="http://' . $this->_domain . '#';

		// 1. Parse HTML content and display according protocol:
		if(true === $this->_switch) {
			$buffer = preg_replace($external, '$1="//$2"', $buffer);
			$buffer = preg_replace($internal, '$1="' . $this->_https . '://' . $this->_domain, $buffer);
			$buffer = preg_replace($form_val, '$1="' . $this->_https . '://' . $this->_domain, $buffer);
			$buffer = str_replace('http:\/\/' . $this->_domain, 'https:\/\/' . $this->_domain, $buffer);
		//	$buffer = str_replace(get_bloginfo('url'), get_bloginfo('wpurl'), $buffer);
		}

		// 2. Minify HTML source:
		if(true === $this->_minify && !is_admin()) {
			if(function_exists('fn_minify_html')) {
				$buffer = fn_minify_html($buffer);
			}
		}

		// 3. Minify CSS comments:
		if(true === $this->_mn_css && !is_admin()) {
			if(function_exists('fn_minify_css_union')) {
				$buffer = fn_minify_css_union($buffer);
			}
		}

		// 4. Minify JS comments:
		if(true === $this->_min_js && !is_admin()) {
			if(function_exists('fn_minify_js_union')) {
				$buffer = fn_minify_js_union($buffer);
			}
		}

		return $buffer;
	}

	public function buffy_sidebar_output() {
		// widget_recent_entries
		echo '<!-- test sidebar -->_';
	}

	public function buffy_proto_testing() {
		$this->_https = strpos($_SERVER['SERVER_PORT'], '80') === false ? 'https': 'http';
		?> <!-- protocole = <?php echo $_SERVER['SERVER_PORT']; ?>, requested protocol = <?php echo $this->_https ?>, $var testing <?php $var = (strpos($_SERVER['SERVER_PORT'], '80') > -1); var_export( $var, false ); ?>, ssl is <?php $ssl_is = (true === is_ssl()) ? 'on': 'off'; echo ssl_is ?> -->

		<?php
	}
	/********************************
	 * Register plugin options:
	 */
	public function buffy_flush_options() {

		if (is_multisite() && is_plugin_active_for_network(plugin_basename(__FILE__))) {
		    $sites = wp_get_sites();
		    foreach($sites as $site) {
			delete_blog_option($site['blog_id'], 'buffy_options_array');
		    }
		} else {
			delete_option('buffy_options_array');
		}
		unregister_setting('buffy_options_group', 'buffy_options_array');
	}

	public function buffy_settings_register() {
		register_setting('buffy_options_group', 'buffy_options_array', array($this, 'buffy_san_options'));
	}

	public function buffy_san_options($options) {
		$nonce = $_POST['_wpnonce'];
		$wp_verify_nonce = wp_verify_nonce($_POST['_wpnonce'], 'buffy_options_array');
		$wp_http_referer = array('/wp-admin/options-general.php?page=buffyopt', '/wp-admin/options-general.php?page=buffyopt&settings-updated=true');
		/*****************************
		array(6) { ["option_page"]=> string(19) "buffy_options_group" ["action"]=> string(6) "update" ["_wpnonce"]=> string(10) "951356f691" ["_wp_http_referer"]=> string(43) "/wp-admin/options-general.php?page=buffyopt" ["buffy_options_group"]=> array(2) { ["switch"]=> string(1) "0" ["minify"]=> string(1) "0" } ["buffy_options_group_button"]=> string(29) "Enregistrer les modifications" }

		$_POST['buffy_options_group']['nonce'] = $nonce;
		$_POST['buffy_options_group']['verif'] = $wp_verify_nonce;
		 ****************************/
		if( isset($_POST['option_page']) /* && (1 == wp_verify_nonce($_POST['_wpnonce'], 'update')) */ && in_array($_POST['_wp_http_referer'], $wp_http_referer, true) ) {
		    if(is_array($_POST['buffy_options_group']) && !empty($_POST['buffy_options_group'])) {
			// return wp_verify_nonce($_POST['_wpnonce'], 'update');
			return $_POST['buffy_options_group'];
		    } else {
			return array('switch' => '0', 'minify'=> '0', 'mn_css'=> '0', 'min_js'=> '0');
		    }
		}
	}

	public function buffy_options_panel() {
		if (is_multisite() && is_plugin_active_for_network(plugin_basename(__FILE__))) {
		    $this->_options = get_blog_option($this->_blog_id, 'buffy_options_array', array('switch' => (bool)$this->_switch, 'minify'=> (bool)$this->_minify, 'mn_css'=> (bool)$this->_mn_css, 'min_js'=> (bool)$this->_min_js));
		} else {
		    $this->_options = get_option('buffy_options_array', array('switch' => (bool)$this->_switch, 'minify'=> (bool)$this->_minify, 'mn_css'=> (bool)$this->_mn_css, 'min_js'=> (bool)$this->_min_js));
		}
		$options = $this->_options;
		$this->_switch = (bool)$options['switch'];
		$this->_minify = (bool)$options['minify'];
		$this->_mn_css = (bool)$options['mn_css'];
		$this->_min_js = (bool)$options['min_js'];
		settype($this->_switch, 'bool');
		settype($this->_minify, 'bool');
		settype($this->_mn_css, 'bool');
		settype($this->_min_js, 'bool');
		?> <div class="wrap">
			<style>
				.container { width: 80%; border: 2px dashed rgb(46, 162, 204); margin: 70px auto auto 10%; padding-bottom: 25px; padding-right: 25px; }
				table { width: 100%; padding: 15px 0 0 15px; }
				td { text-align: left; }
				#buffy_options_group { float: right; }
				#buffy_options_group_button { float: right; }
			</style>
			<h2><?php _e('Bufferised Output Options:', 'simple-html-minifier') ?></h2>
<?php // tests
/*************************
var_dump($this->_options);
echo '<hr />';
if (is_multisite()) {
	var_dump(get_blog_option($this->_blog_id, 'buffy_options_array'));
} else {
	var_dump(get_option('buffy_options_array'));
}
echo '<hr />';
var_dump($this->_switch);
var_dump($this->_minify);
var_dump($this->_mn_css);
var_dump($this->_min_js);
var_dump($this->_https);
var_dump($this->_options);
echo '<hr />';
var_dump($this->buffy_network_ctrl());
echo '<hr />';
var_dump(wp_nonce_field('','_wp_http_referer'));
 ************************/
?>
			    <form method="POST" action="options.php">
				<?php settings_fields('buffy_options_group'); ?>
				<?php do_settings_fields('buffy_options_group', ''); ?>
				    <div class="container"><table>
					<tr> <td> <label for="buffy_options_group[switch]"><?php printf(esc_html__('Switch Protocol to %s', 'simple-html-minifier'), $this->_https); ?>:</label> </td> <td>
					    <input type="radio" name="buffy_options_group[switch]" value="1" <?php checked((int)$this->_switch, 1, true); ?>" /> <?php _e('yes', 'simple-html-minifier'); ?>
					    <input type="radio" name="buffy_options_group[switch]" value="0" <?php checked((int)$this->_switch, 0, true); ?>" /> <?php _e('no', 'simple-html-minifier'); ?>
					</td> </tr>

					<tr> <td> <label for="buffy_options_group[minify]"><?php _e('Minify HTML Pages:', 'simple-html-minifier') ?></label> </td> <td>
					    <input type="radio" name="buffy_options_group[minify]" value="1" <?php checked((int)$this->_minify, 1, true); ?>" /> <?php _e('yes', 'simple-html-minifier'); ?>
					    <input type="radio" name="buffy_options_group[minify]" value="0" <?php checked((int)$this->_minify, 0, true); ?>" /> <?php _e('no', 'simple-html-minifier'); ?>
					</td> </tr>

					<tr> <td> <label for="buffy_options_group[mn_css]"><?php _e('Strip CSS comments:', 'simple-html-minifier') ?></label> </td> <td>
					    <input type="radio" name="buffy_options_group[mn_css]" value="1" <?php checked((int)$this->_mn_css, 1, true); ?>" /> <?php _e('yes', 'simple-html-minifier'); ?>
					    <input type="radio" name="buffy_options_group[mn_css]" value="0" <?php checked((int)$this->_mn_css, 0, true); ?>" /> <?php _e('no', 'simple-html-minifier'); ?>
					</td> </tr>

					<tr> <td> <label for="buffy_options_group[min_js]"><?php _e('Strip JS comments:', 'simple-html-minifier') ?></label> </td> <td>
					    <input type="radio" name="buffy_options_group[min_js]" value="1" <?php checked((int)$this->_min_js, 1, true); ?>" /> <?php _e('yes', 'simple-html-minifier'); ?>
					    <input type="radio" name="buffy_options_group[min_js]" value="0" <?php checked((int)$this->_min_js, 0, true); ?>" /> <?php _e('no', 'simple-html-minifier'); ?>
					</td> </tr>
				    </table>
				<?php submit_button('', 'primary', 'buffy_options_group_button'); ?> </div>
			    </form>
		</div> <?php /*
				$textdomain = load_plugin_textdomain('simple-html-minifier', false, dirname(plugin_basename(__FILE__))) ? 'yes' : 'no';
				echo $textdomain; */
	}

}

$BuffyOutput = new BuffyOutput();

?>